import {
  Text,
  SafeAreaView,
  TouchableOpacity,
  Alert,
  Image,
} from "react-native";
import React, {
  forwardRef,
  useEffect,
  useImperativeHandle,
  useRef,
  useState,
} from "react";
import { collection, getDocs, query } from "firebase/firestore";
import { db } from "../../../config/firebase";
import { DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING } from "../../styles/constants";
import { FlashList } from "@shopify/flash-list";
import PageLoader from "../../components/Loaders/PageLoader";
import { useTranslation } from "react-i18next";

const SearchStep2 = forwardRef((props, ref) => {
  const { updateStepData, goToNextPage } = props;
  const { t, i18n } = useTranslation();
  const [cat, setCat] = useState(null);
  const [cats, setCats] = useState([]);
  const [isLoading, setIsLoading] = useState(true);

  const localRef = useRef();

  useEffect(() => {
    getCategories();
  }, []);


  async function getCategories() {
    setIsLoading(true);
    const q = query(collection(db, "categories"));
    const querySnapshot = await getDocs(q);
    const dataArr = [];
    querySnapshot.forEach(async (res) => {
      dataArr.push({
        id: res.id,
        ...res.data(),
      });
    });

    dataArr.sort(customSort);
    setCats(dataArr);
    setTimeout(() => {
      setIsLoading(false);
    }, 2000);
  }

  const customSort = (a, b) => {
    const nameA = a.name.toLowerCase();
    const nameB = b.name.toLowerCase();

    // Mettre "voiture" en premier
    if (nameA.startsWith("voiture") && !nameB.startsWith("voiture")) {
      return -1;
    }
    if (!nameA.startsWith("voiture") && nameB.startsWith("voiture")) {
      return 1;
    }

    // Trier par ordre alphabétique
    return nameA.localeCompare(nameB);
  };

  useImperativeHandle(ref, () => ({
    async validate(item) {
      if (!item) {
        Alert.alert("Veuillez choisir un type de véhicule");

        return;
      }
      console.log(item);
      updateStepData("step2", { cat: item });
      goToNextPage();
    },
  }));


  localRef.current = ref?.current;

  const handleValidate = (item) => {
    if (localRef.current) {
      localRef.current.validate(item);
    }
  };

  if (isLoading) {
    return <PageLoader />;
  }

  return (
    <SafeAreaView className="flex-1 bg-white">
      <FlashList
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING / 2,
        }}
        data={cats}
        renderItem={({ item }) => (
          <TouchableOpacity
            className="flex-row items-center p-2 border-b border-gray-200"
            onPress={() => {
              console.log(item)
              handleValidate(item.name);
              // handleValidate(item.name.toLowerCase());
            }}
          >
            <Image
              className="mr-3 w-14 h-14 z-20 rounded-full"
              source={{ uri: item.image }}
              resizeMode={"cover"}
            />
            <Text
              style={{ fontFamily: "Inter_400Regular" }}
              className="text-base"
            >
              {item.name.charAt(0).toUpperCase() + item.name.slice(1)}
            </Text>
          </TouchableOpacity>
        )}
        keyExtractor={(item) => item.name.toString()}
        estimatedItemSize={20}
      />
    </SafeAreaView>
  );
});
export default SearchStep2;
